/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.LevelFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import org.slf4j.LoggerFactory;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.log.LogCallbackAppender;

public class SonarLintLogging {
    private static final String CUSTOM_APPENDER_NAME = "custom_stream";
    private static final String DEFAULT_APPENDER_NAME = "default_appender";
    private static LogCallbackAppender appender;

    private SonarLintLogging() {
    }

    public static void set(LogOutput output) {
        appender.setTarget(output);
    }

    private static void init() {
        ConsoleAppender<ILoggingEvent> defaultAppender = new ConsoleAppender<ILoggingEvent>();
        defaultAppender.setContext((LoggerContext)LoggerFactory.getILoggerFactory());
        defaultAppender.setName(DEFAULT_APPENDER_NAME);
        LevelFilter levelFilter = new LevelFilter();
        levelFilter.setLevel(Level.ERROR);
        defaultAppender.addFilter(levelFilter);
        SonarLintLogging.setCustomRootAppender(defaultAppender);
    }

    private static void setCustomRootAppender(Appender<ILoggingEvent> defaultAppender) {
        Logger logger = (Logger)LoggerFactory.getLogger("ROOT");
        logger.detachAndStopAllAppenders();
        appender = new LogCallbackAppender(defaultAppender);
        appender.setName(CUSTOM_APPENDER_NAME);
        appender.start();
        logger.addAppender(appender);
    }

    static {
        SonarLintLogging.init();
    }
}

